﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.CRM.Plugins.Helper;

namespace VA.PPMS.CRM.Plugins.Data
{
    public class PpmsServiceSettings
    {
        public enum Environments
        {
            Dev = 767940000,
            NonProd = 767940001,
            Prod = 767940002
        }

        #region Properties

        public string Domain { get; set; }

        public string StorageAccountResource { get; set; }

        public Environments Environment { get; set; }

        public string ErrorMessage { get; set; }

        public string QueueBaseAddress
        {
            get { return $"https://{Domain}.queue.core.usgovcloudapi.net/"; }
        }

        public string TableBaseAddress
        {
            get { return $"https://{Domain}.table.core.usgovcloudapi.net/"; }
        }

        public string StorageAccountKey { get; set; }

        public string StorageAccountName { get; set; }

        public string SpBaseUrl { get; set; }

        public string SpLibrary { get; set; }

        public string SpDomain { get; set; }

        public string SpId { get; set; }

        public string SpCode { get; set; }

        public bool IsValid
        {
            get { return !string.IsNullOrEmpty(Domain) && !string.IsNullOrEmpty(StorageAccountResource); }
        }

        #endregion

        #region Constructors

        public PpmsServiceSettings() { }

        public PpmsServiceSettings(ppms_integrationsettings settings)
            : base()
        {
            if (settings != null)
            {
                Domain = settings.ppms_servicedomain;
                StorageAccountResource = settings.ppms_NPPESStorageAccountResource.Trim();
                Environment = (Environments)settings.ppms_environment.Value;
                StorageAccountName = settings.ppms_servicedomain;
                SpBaseUrl = settings.ppms_spbaseurl;
                SpLibrary = settings.ppms_splibrary;
                SpDomain = settings.ppms_spdomain;
                SpId = settings.ppms_spid;
            }
        }

        public PpmsServiceSettings(string errorMsg)
            : base()
        {
            ErrorMessage = errorMsg;
        }

        #endregion
    }
}
